/*------------------------------------------------------------------------------*
 * File Name: Image.c				 											*
 * Creation: 																	*
 * Purpose: Origin C Source for Image import filter								*
 * Copyright (c) OriginLab Corp. 2003, 2004, 2005								*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 01-27-2003 v7.5808 QA70-1352 IMPORT_MULTIPLE_IMAGES_INTO_MATRIX			*
 * EJP 2005-07-21 v8.0273 QA70-7891 ACCESS_LEADTOOLS_FROM_OC					*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// you can include just this typical header file for most Origin built-in functions and classes
// and it takes a reasonable amount of time to compile, 
#include <origin.h>
#include <Tree.h>
#include "fu_utils.h"

/// EJP 01-27-2003 v7.5808 QA70-1352 IMPORT_MULTIPLE_IMAGES_INTO_MATRIX
#if _OC_VER >= 0x0800
#include <import_image.h>
#endif //_OC_VER >= 0x0800
/// end IMPORT_MULTIPLE_IMAGES_INTO_MATRIX

/// EJP 2005-07-21 v8.0273 QA70-7891 ACCESS_LEADTOOLS_FROM_OC
typedef int (*PFNLOADIMGINMAT)(MatrixLayer& mlTarget, LPCSTR lpcszFile);
/// end ACCESS_LEADTOOLS_FROM_OC

// this file include most of the other header files except the NAG header, which takes longer to compile
// NAG routines
//#include <OC_nag.h> // this contains all the NAG headers, 

////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// start your functions here

int ImportImage(Page &pgTarget, TreeNode &trFilter, LPCSTR lpcszFile, int nFile)
{
	if( EXIST_MATRIX != pgTarget.GetType() )
		return 1; // target page is required
	if( !trFilter || trFilter.Type.nVal != FILTER_TYPE_USERDEFINED )
		return 1; // user defined filter is required
	if( !lpcszFile )
		return 1; // source file name is required

	/// EJP 2005-07-21 v8.0273 QA70-7891 ACCESS_LEADTOOLS_FROM_OC
	/*
	using Image = LabTalk.Image;
	
	Image.FileName$ = lpcszFile;
	
	string strPageName = pgTarget.GetName();
	if( Image.Import.Matrix(strPageName) )
		return 1; // import error
	pgTarget.LT_execute("matrix -ii"); // show matrix as image
	*/
	MatrixLayer mlTarget = pgTarget.Layers();
	if( !mlTarget )
		return 1;
	PFNLOADIMGINMAT pfn = Project.FindFunction("image_import_to_matrix_sheet", "OriginLab\\image_utils.c");
	if( !pfn || pfn(mlTarget, lpcszFile) < 1 )
		return 1;
	/// end ACCESS_LEADTOOLS_FROM_OC
	
	return 0;
}

#if _OC_VER >= 0x0800

/// EJP 01-27-2003 v7.5808 QA70-1352 IMPORT_MULTIPLE_IMAGES_INTO_MATRIX
int ImportMultipleImages(string strMatrix)
{
	MatrixPage pg(strMatrix);
	if( pg )
		return ImportMultipleImages(pg);
	return 1; // error, 
}

int ImportMultipleImages(MatrixPage &pgTarget)
{
	StringArray saFiles;
	if( GetMultiOpenBox(saFiles, FDLOG_IMAGE) )
	{
		using Image = LabTalk.Image;

		Tree trFiles;
		string str, strPage = pgTarget.GetName();

		for( int iFile = 0; iFile < saFiles.GetSize(); iFile++ )
		{
			Image.FileName$ = saFiles[iFile];

			str.Format(IMPORT_FILE_ENUM "%d", iFile + 1);//  File1,File2 etc
			Image.Import.Object(strPage, str, 1); // 1=replace
			
			AppendImageFileNode(trFiles, str, saFiles[iFile]);

			str += ".show=0";
			pgTarget.LT_execute(str); // hide GrObject
		}
		
		///out_tree(trFiles); // for debugging
		vector<byte> vb;
		if( trFiles.XML.GetBytes(vb) )
		{
			pgTarget.SetMemory(IMPORT_FILE_INFO, vb);
			//CPY 2/8/04
			MatrixLayer ml = pgTarget.Layers();
			if(ml)
			{
				ml.SetViewImage(TRUE, IMGV_FILE, 0);// view 1st file
				return 0;
			}
		}
	}
	return 1;//err
}

static BOOL AppendImageFileNode(Tree& tr, LPCSTR lpcstrNode, LPCSTR lpcstrFile)
{
	if( !tr || !lpcstrNode || !lpcstrFile )
		return FALSE; // all arguments required

	TreeNode trnFile = tr.AddNode(lpcstrNode);
	if( !trnFile )
		return FALSE;
	
	trnFile.ID = 1;
	trnFile.AddTextNode(GetFileName(lpcstrFile), IMPORT_FILE_INFO_NAME);
	trnFile.AddTextNode(lpcstrFile, IMPORT_FILE_INFO_PATH);
	
	// file date
	double dJulianDate = 0.0;
	WIN32_FILE_ATTRIBUTE_DATA fad;
	if( GetFileAttributesEx(lpcstrFile, 0, &fad) )
	{
		SYSTEMTIME st;
		if( FileTimeToSystemTime(&fad.ftLastWriteTime, &st) )
			SystemTimeToJulianDate(&dJulianDate, &st);
	}
	trnFile.AddNumericNode(dJulianDate, IMPORT_FILE_INFO_DATE);

	using Image = LabTalk.Image;
	string strFile = lpcstrFile;
	Image.FileInfo(strFile);
	trnFile.AddNumericNode(Image.FileInfo.Height, IMPORT_FILE_INFO_HEIGHT);
	trnFile.AddNumericNode(Image.FileInfo.Width, IMPORT_FILE_INFO_WIDTH);
	trnFile.AddNumericNode(Image.FileInfo.BitsPerPixel, IMPORT_FILE_INFO_BITS);
	
	return TRUE;
}
/// end IMPORT_MULTIPLE_IMAGES_INTO_MATRIX

#endif //_OC_VER >= 0x0800
